/*
   This program demonstrates the Java API for creating a process
   and passing it some command-line arguments.

   See
      http://docs.oracle.com/javase/6/docs/api/java/lang/Runtime.html#getRuntime()
      http://docs.oracle.com/javase/6/docs/api/java/lang/Runtime.html#method_summary
*/

public class RunProgramWithArguments
{
   public static void main(String[] args)
   {
      try
      {
         // Create a command-line for running another program.
         // Notice that this is a CLI program with several
         // command-line arguments.
         String cmd = "java CommandLineArguments " +
                      " a " +
                      " b " +
                      " c " +
                      " d ";
         // Execute the command line.
         java.lang.Runtime.getRuntime().exec(cmd);
         // NOTE: There is no output from running this program.
         //       It should print output on the console screen,
         //       but it does not. This is one of the problems
         //       with having Java start up processes.
      }
      catch (Exception e)
      {
         System.out.println( e );
      }
   }//main()
}//RunProgramWithArguments